<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\OurEvent;
use Illuminate\Support\Facades\Input;
use File;
use Image;
use Auth;

class OurEventController extends Controller
{
    public function index()
    {
        $data['page_title'] = "Our Events";
        $data['ourEvent'] = OurEvent::all();
        return view('admin.events.index', $data);
    }

    public function store(Request $request)
    {
        $request->validate([
            'details' => 'required',
            'icon' => 'required',
            'title' => 'required'
        ]);
        $in = input::except('_token');
        OurEvent::create($in);

        $notify = array('message' => 'Saved Successfully.', 'alert-type' => 'success');
        return back()->with($notify);
    }



    public function delete(Request $request)
    {
        $data = OurEvent::findOrFail($request->id);
        $data->delete();
        $notification = array('message' => 'Deleted Successfully.', 'alert-type' => 'success');
        return back()->with($notification);

    }
}
